/**
 * Created by kerry on 2018/5/28.
 */
!(function () {
    if (!window.PluginUtils) {
        window.PluginUtils = {};
    }
    var Dec = window.parent.Dec || {};
    var BI = window.parent.BI || {};
    BI.extend(PluginUtils, {

        installPluginOnline: function (val, callback) {
            Dec.reqPost("/v10/plugin/store/installation?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        installPluginFromDisk: function (val, callback) {
            Dec.reqPost("/v10/plugin/disk/installation?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        uninstallPlugin: function (val, callback) {
            Dec.reqDelete("/v10/plugin/installation?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        updatePluginOnline: function (para, body, callback) {
            Dec.reqPut("/v10/plugin/store/installation?" + Dec.Utils.transformObject2URLParam(para, null, false), body, callback);
        },
        updatePluginFromDisk: function (val, callback) {
            Dec.reqPut("/v10/plugin/disk/installation?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        setPluginActive: function (val, callback) {
            Dec.reqPut("/v10/plugin/installation/status?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        searchPlugin: function (val, callback) {
            Dec.reqGet("/v10/plugin/store/search?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        reqGetInstallPluginUpdateList: function (callback) {
            Dec.reqGet("/v10/plugin/installation/update", {}, callback);
        },
        reqGetPluginCategories: function (callback) {
            Dec.reqGet("/v10/plugin/store/category", {}, callback);
        },
        reqGetLoginInfo: function (callback) {
            Dec.reqGet("/v10/plugin/store/login", {}, callback);
        },
        registerLoginInfo: function (val, callback) {
            Dec.reqGet("/v10/plugin/store", val, callback);
        },
        reqGetInstalledPlugins: function (val, callback) {
            Dec.reqGet("/v10/plugin/installation", val, callback);
        },
        reqGetPluginFromStore: function (val, callback) {
            Dec.reqGet("/v10/plugin/store?" + Dec.Utils.transformObject2URLParam(val, null, false), val, callback);
        },
        reqGetPluginPrefix: function (callback) {
            Dec.reqGet("/v10/plugin/store/url", {}, callback);
        },
        defaultLogin: function (val, callback) {
            Dec.reqPost("/v10/plugin/store/login", val, callback);
        },
        ucsynLogin: function (val, callback) {
            Dec.reqPut("/v10/plugin/store/login/sync", val, callback);
        },
        clearUserInfo: function (callback) {
            Dec.reqDelete("/v10/plugin/store/login", {}, callback);
        },

        reqGetProjectInfo: function (callback) {
            Dec.reqGet("/v10/plugin/store/project", {}, callback);
        },

        showNeededDialog: function (msgInfo) {
            var pane = {
                type: "dec.tip.popover",
                text: msgInfo,
                listeners: [
                    {
                        eventName: "EVENT_CLOSE",
                        action: function () {
                            BI.Popovers.remove("infoDialog");
                        }
                    }
                ]
            };

            BI.Popovers.create("infoDialog", {
                type: "bi.popover",
                header: BI.i18nText("Dec-Basic_Tips"),
                body: pane,
                width: 450,
                height: 220,
            }).open("infoDialog");
        },

        showConfirmDialog: function (msgInfo, callback) {
            var pane = {
                type: "dec.delete.confirm.popover",
                text: msgInfo,
                onClickConfirm: function () {
                    callback.call(this);
                },
                listeners: [
                    {
                        eventName: "EVENT_CLOSE",
                        action: function () {
                            BI.Popovers.remove("confirmDialog");
                        }
                    }
                ]
            };

            BI.Popovers.create("confirmDialog", {
                type: "bi.popover",
                header: BI.i18nText("Dec-Basic_Tips"),
                body: pane,
                width: 450,
                height: 220,
            }).open("confirmDialog");
        }

    });

})();