/**
 *@param {JSON} config 对话框的配置属性
 *@param {String} arguments 对话框展示的文本信息
 *@static
 */
!(function () {
    var BI = window.parent.BI || {};
    var TipPopover = BI.inherit(BI.Widget, {

        props: {
            text: "",
            onClickConfirm: BI.emptyFn,
            btn: BI.i18nText(BI.i18nText("Dec-Basic_Sure"))
        },

        render: function () {
            return {
                type: "bi.vtape",
                items: [
                    {
                        el: this.rebuildCenter()
                    }, {
                        el: this.rebuildSouth(),
                        height: 44
                    }
                ]
            };
        },

        rebuildCenter: function () {
            return {
                type: "bi.label",
                text: this.options.text,
                height: 50,
                textAlign: "left"
            };
        },

        rebuildSouth: function () {
            var self = this, o = this.options;
            var sure = BI.createWidget({
                type: "bi.button",
                ref: function (_ref) {
                    self.sure = _ref;
                },
                text: this.options.btn,
                warningTitle: o.warningTitle,
                height: 30,
                value: 0,
                handler: function () {
                    self.end();
                }
            });
            return {
                type: "bi.right_vertical_adapt",
                lgap: 10,
                items: [sure]
            };
        },

        close: function () {
            this.fireEvent("EVENT_CLOSE");
        },
        end: function () {
            this.options.onClickConfirm();
            this.fireEvent("EVENT_CLOSE");
        }
    });

    BI.shortcut("dec.tip.popover", TipPopover);
}());

